package com.ejie.ab04b.util.converter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.Obra;
import com.ejie.ab04b.model.Promotor;
import com.ejie.ab04b.model.Proyectista;
import com.ejie.ab04b.model.TipoApertura;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.PlateaTramitacionUtils;
import com.ejie.ab04b.util.ToolkitUtils;
import com.ejie.ab04b.util.Utilities;
import com.ejie.detailinfo.aperturassoltel.xml.Datosrepresentative1;
import com.ejie.detailinfo.aperturassoltel.xml.DetailInfo;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoCoordinadores;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoDatosCentroTrabajo;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoDatosEmpresa;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoDatosObra;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoPromotor;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoProyectistas;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoTablaCoordinadorEjecucionObra;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoTablaCoordinadorElaboracionProyecto;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoTablaOtrosPromotores;
import com.ejie.detailinfo.aperturassoltel.xml.GrupoTablaProyectistas;
import com.ejie.foldermanagement.xml.ContextSubmissionEvent;

/**
 * @author GFI-NORTE
 * 
 */
public final class AperturaSolTelConverter {

	private static AperturaSolTelConverter instance;

	/**
	 * Constructor privado.
	 */
	private AperturaSolTelConverter() {

	}

	/**
	 *  ToolkitParameterUtils.
	 *
	 * @return single instance of AperturaSolTelConverter
	 */
	public static AperturaSolTelConverter getInstance() {
		if (AperturaSolTelConverter.instance == null) {
			AperturaSolTelConverter.instance = new AperturaSolTelConverter();
		}
		return AperturaSolTelConverter.instance;
	}

	/**
	 *  datosObra
	 *            GrupoDatosObra
	 *  Obra.
	 *
	 * @param datosObra the datos obra
	 * @return the obra
	 */
	public Obra crearObraDetailInfo(GrupoDatosObra datosObra) {

		Obra obra = new Obra();
		obra.setTipobr082(datosObra.getCampoTipoObra());
		obra.setIndanx2082(ToolkitUtils.getInstance().convertirRadioSiNo(
				datosObra.getCampoRadioTrabajosAnexoII()));
		obra.setApdoanx2082(datosObra.getCampoApartadoAnexoII());
		obra.setDestrab082(datosObra.getCampoDescripcionTrabajoActividad());
		obra.setPrvobr082(datosObra.getGrupoDireccionObra()
				.getCampoProvinciaDireccionObra());
		obra.setMunobr082(datosObra.getGrupoDireccionObra()
				.getCampoMunicipioDireccionObra());
		obra.setLocobr082(datosObra.getGrupoDireccionObra()
				.getCampoLocalidadDireccionObra());
		obra.setDirobr082(ToolkitUtils.getInstance()
				.concatenarDireccionToolkit(
						datosObra.getGrupoDireccionObra()
								.getCampoCalleDireccionObra(),
						datosObra.getGrupoDireccionObra()
								.getCampoNumPortalDireccionObra(), null, null));
		obra.setFecini082(ToolkitUtils.getInstance().parsearFecha(
				datosObra.getFechaInicioObras()));
		obra.setDesobr082(datosObra.getCampoDescripcionObra());
		obra.setDurpre082(datosObra.getCampoDuracionTrabajos());
		obra.setUnitmp082(datosObra.getCampoUnidadDuracionObras());
		if (datosObra.getCampoNumTrabajadoresEstimadosHombres() != null) {
			obra.setTrbhom082(Long.parseLong(datosObra
					.getCampoNumTrabajadoresEstimadosHombres()));
		}
		if (datosObra.getCampoNumTrabajadoresEstimadosMujeres() != null) {
			obra.setTrbmuj082(Long.parseLong(datosObra
					.getCampoNumTrabajadoresEstimadosMujeres()));
		}
		if (datosObra.getCampoNumTrabajadoresEstimadosTotal() != null) {
			obra.setTrbtot082(Long.parseLong(datosObra
					.getCampoNumTrabajadoresEstimadosTotal()));
		}

		return obra;
	}

	/**
	 *  detailInfo
	 *            DetailInfo
	 *  List<Promotor>.
	 *
	 * @param detailInfo the detail info
	 * @return the list
	 */
	public List<Promotor> crearListaPromotoresDetailInfo(DetailInfo detailInfo) {

		GrupoPromotor datosPromotor = detailInfo.getGrupoPromotor();

		List<Promotor> listaPromotores = new ArrayList<Promotor>();

		if (datosPromotor != null
				&& !Utilities.getInstance().isEmpty(
						datosPromotor.getCampoNIFCIFPromotor())) {
			// Creamos al promotor principal
			Promotor promotorPrincipal = new Promotor();
			promotorPrincipal.setTipdoc085(ToolkitUtils.getInstance()
					.convertirTipoIdentificacion(
							datosPromotor.getCampoTipoIdentPromotor()));
			promotorPrincipal.setTipoprm085(Constantes.PROMOTOR_PRINCIPAL);
			promotorPrincipal.setNumdoc085(datosPromotor
					.getCampoNIFCIFPromotor());
			promotorPrincipal.setNomprm085(datosPromotor
					.getCampoNombrePromotor());
			promotorPrincipal.setPaisprm085(datosPromotor
					.getCampoPaisPromotor());

			promotorPrincipal.setPaisprm085(datosPromotor
					.getCampoPaisPromotor());
			promotorPrincipal.setPrvprm085(datosPromotor
					.getCampoProvinciaPromotor());
			promotorPrincipal.setMunprm085(datosPromotor
					.getCampoMunicipioPromotor());
			promotorPrincipal.setDirprm085(ToolkitUtils.getInstance()
					.concatenarDireccionToolkit(
							datosPromotor.getCampoCallePromotor(),
							datosPromotor.getCampoNumPortalPromotor(), null,
							null));
			promotorPrincipal.setCpoprm085(datosPromotor
					.getCampoCodPostalPromotor());

			listaPromotores.add(promotorPrincipal);

			// Creamos a los promotores secundarios
			if (datosPromotor.getGrupoOtrosPromotores() != null
					&& datosPromotor.getGrupoOtrosPromotores()
							.getGrupoTablaOtrosPromotores() != null
					&& datosPromotor.getGrupoOtrosPromotores()
							.getGrupoTablaOtrosPromotores().getElementoGR() != null) {

				for (int i = 0; i < datosPromotor.getGrupoOtrosPromotores()
						.getGrupoTablaOtrosPromotores().getElementoGR().size(); i++) {

					GrupoTablaOtrosPromotores.ElementoGR elem = datosPromotor
							.getGrupoOtrosPromotores()
							.getGrupoTablaOtrosPromotores().getElementoGR()
							.get(i);
					GrupoTablaOtrosPromotores.ElementoGRValores elemValores = datosPromotor
							.getGrupoOtrosPromotores()
							.getGrupoTablaOtrosPromotores()
							.getElementoGRValores().get(i);

					Promotor promotorSecun = new Promotor();
					promotorSecun
							.setTipdoc085(ToolkitUtils
									.getInstance()
									.convertirTipoIdentificacion(
											elemValores
													.getCampoTipoIdentOtrosPromotores()));
					promotorSecun.setTipoprm085(Constantes.PROMOTOR_SECUNDARIO);
					promotorSecun.setNumdoc085(elem
							.getCampoNIFCIFOtrosPromotores());
					promotorSecun.setNomprm085(elem
							.getCampoNombreOtrosPromotores());
					promotorSecun.setPaisprm085(elemValores
							.getCampoPaisOtrosPromotores());
					promotorSecun.setPrvprm085(elemValores
							.getCampoProvinciaOtrosPromotores());
					promotorSecun.setMunprm085(elemValores
							.getCampoMunicipioOtrosPromotores());
					promotorSecun.setDirprm085(ToolkitUtils.getInstance()
							.concatenarDireccionToolkit(
									elem.getCampoCalleOtrosPromotores(),
									elem.getCampoNumPortalOtrosPromotores(),
									null, null));
					promotorSecun.setCpoprm085(elem
							.getCampoCodPostalOtrosPromotores());

					listaPromotores.add(promotorSecun);
				}
			}
		}

		return listaPromotores;
	}

	/**
	 *  detailInfo
	 *            DetailInfo
	 *  List<CoordinadorObra>.
	 *
	 * @param detailInfo the detail info
	 * @return the list
	 */
	public List<CoordinadorObra> crearListaCoordinadoresDetailInfo(
			DetailInfo detailInfo) {

		GrupoCoordinadores datosCoordinadores = detailInfo
				.getGrupoCoordinadores();

		List<CoordinadorObra> listaCoodinadores = new ArrayList<CoordinadorObra>();

		if (datosCoordinadores != null) {
			// Creamos a los coordinadores de elaboración de proyecto
			if (datosCoordinadores.getGrupoCoordinadorElaboracionProyecto() != null
					&& datosCoordinadores
							.getGrupoCoordinadorElaboracionProyecto()
							.getGrupoTablaCoordinadorElaboracionProyecto() != null
					&& datosCoordinadores
							.getGrupoCoordinadorElaboracionProyecto()
							.getGrupoTablaCoordinadorElaboracionProyecto()
							.getElementoGR() != null) {

				for (int i = 0; i < datosCoordinadores
						.getGrupoCoordinadorElaboracionProyecto()
						.getGrupoTablaCoordinadorElaboracionProyecto()
						.getElementoGR().size(); i++) {

					GrupoTablaCoordinadorElaboracionProyecto.ElementoGR elem = datosCoordinadores
							.getGrupoCoordinadorElaboracionProyecto()
							.getGrupoTablaCoordinadorElaboracionProyecto()
							.getElementoGR().get(i);
					GrupoTablaCoordinadorElaboracionProyecto.ElementoGRValores elemValores = datosCoordinadores
							.getGrupoCoordinadorElaboracionProyecto()
							.getGrupoTablaCoordinadorElaboracionProyecto()
							.getElementoGRValores().get(i);

					CoordinadorObra coordinadorProyecto = new CoordinadorObra();
					coordinadorProyecto
							.setTipcrd084(Constantes.COORDINADOR_ELABORACION_PROYECTO);
					coordinadorProyecto
							.setTipdoc084(ToolkitUtils
									.getInstance()
									.convertirTipoIdentificacion(
											elemValores
													.getCampoTipoIdentCoordinadorElaboracionObra()));
					coordinadorProyecto.setNumdoc084(elem
							.getCampoNIFCIFCoordinadorElaboracionObra());
					coordinadorProyecto.setNomcrd084(elem
							.getCampoNombreCoordinadorElaboracionObra());
					coordinadorProyecto.setPaiscrd084(elemValores
							.getCampoPaisCoordinadorElaboracionObra());
					coordinadorProyecto.setPrvcrd084(elemValores
							.getCampoProvinciaCoordinadorElaboracionObra());
					coordinadorProyecto.setMuncrd084(elemValores
							.getCampoMunicipioCoordinadorElaboracionObra());
					coordinadorProyecto
							.setDircrd084(ToolkitUtils
									.getInstance()
									.concatenarDireccionToolkit(
											elem.getCampoCalleCoordinadorElaboracionObra(),
											elem.getCampoNumPortalCoordinadorElaboracionObra(),
											null, null));
					coordinadorProyecto.setCpocrd084(elem
							.getCampoCodPostalCoordinadorElaboracionObra());

					listaCoodinadores.add(coordinadorProyecto);
				}
			}

			// Creamos a los coordinadores de ejecución de obra
			if (datosCoordinadores.getGrupoCoordinadorEjecucionObra() != null
					&& datosCoordinadores.getGrupoCoordinadorEjecucionObra()
							.getGrupoTablaCoordinadorEjecucionObra() != null
					&& datosCoordinadores.getGrupoCoordinadorEjecucionObra()
							.getGrupoTablaCoordinadorEjecucionObra()
							.getElementoGR() != null) {

				for (int i = 0; i < datosCoordinadores
						.getGrupoCoordinadorEjecucionObra()
						.getGrupoTablaCoordinadorEjecucionObra()
						.getElementoGR().size(); i++) {

					GrupoTablaCoordinadorEjecucionObra.ElementoGR elem = datosCoordinadores
							.getGrupoCoordinadorEjecucionObra()
							.getGrupoTablaCoordinadorEjecucionObra()
							.getElementoGR().get(i);
					GrupoTablaCoordinadorEjecucionObra.ElementoGRValores elemValores = datosCoordinadores
							.getGrupoCoordinadorEjecucionObra()
							.getGrupoTablaCoordinadorEjecucionObra()
							.getElementoGRValores().get(i);

					CoordinadorObra coordinadorObra = new CoordinadorObra();
					coordinadorObra
							.setTipcrd084(Constantes.COORDINADOR_EJECUCION_OBRA);
					coordinadorObra
							.setTipdoc084(ToolkitUtils
									.getInstance()
									.convertirTipoIdentificacion(
											elemValores
													.getCampoTipoIdentCoordinadorEjecucionObra()));
					coordinadorObra.setNumdoc084(elem
							.getCampoNIFCIFCoordinadorEjecucionObra());
					coordinadorObra.setNomcrd084(elem
							.getCampoNombreCoordinadorEjecucionObra());
					coordinadorObra.setPaiscrd084(elemValores
							.getCampoPaisCoordinadorEjecucionObra());
					coordinadorObra.setPrvcrd084(elemValores
							.getCampoProvinciaCoordinadorEjecucionObra());
					coordinadorObra.setMuncrd084(elemValores
							.getCampoMunicipioCoordinadorEjecucionObra());
					coordinadorObra
							.setDircrd084(ToolkitUtils
									.getInstance()
									.concatenarDireccionToolkit(
											elem.getCampoCalleCoordinadorEjecucionObra(),
											elem.getCampoNumPortalCoordinadorEjecucionObra(),
											null, null));
					coordinadorObra.setCpocrd084(elem
							.getCampoCodPostalCoordinadorEjecucionObra());
					coordinadorObra.setTlfcrd084(elem
							.getCampoTelefonoCoordinadorEjecucionObra());

					listaCoodinadores.add(coordinadorObra);
				}
			}
		}

		return listaCoodinadores;
	}

	/**
	 *  detailInfo
	 *            DetailInfo
	 *  List<Proyectista>.
	 *
	 * @param detailInfo the detail info
	 * @return the list
	 */
	public List<Proyectista> crearListaProyectistasDetailInfo(
			DetailInfo detailInfo) {

		GrupoProyectistas datosProyectistas = detailInfo.getGrupoProyectistas();

		List<Proyectista> listaProyectistas = new ArrayList<Proyectista>();

		// Creamos a los proyectistas
		if (datosProyectistas != null
				&& datosProyectistas.getGrupoTablaProyectistas() != null
				&& datosProyectistas.getGrupoTablaProyectistas()
						.getElementoGR() != null) {

			for (int i = 0; i < datosProyectistas.getGrupoTablaProyectistas()
					.getElementoGR().size(); i++) {
				GrupoTablaProyectistas.ElementoGR elem = datosProyectistas
						.getGrupoTablaProyectistas().getElementoGR().get(i);
				GrupoTablaProyectistas.ElementoGRValores elemValores = datosProyectistas
						.getGrupoTablaProyectistas().getElementoGRValores()
						.get(i);

				Proyectista proyectista = new Proyectista();
				proyectista.setTipdoc083(ToolkitUtils.getInstance()
						.convertirTipoIdentificacion(
								elemValores.getCampoTipoIdentProyectistas()));
				proyectista.setNumdoc083(elem.getCampoNIFCIFProyectistas());
				proyectista.setNompry083(elem.getCampoNombreProyectistas());
				proyectista.setPaispry083(elemValores
						.getCampoPaisProyectistas());
				proyectista.setPrvpry083(elemValores
						.getCampoProvinciaProyectistas());
				proyectista.setMunpry083(elemValores
						.getCampoMunicipioProyectistas());
				proyectista.setDirpry083(ToolkitUtils.getInstance()
						.concatenarDireccionToolkit(
								elem.getCampoCalleProyectistas(),
								elem.getCampoNumPortalProyectistas(), null,
								null));
				proyectista.setCpopry083(elem.getCampoCodPostalProyectistas());

				listaProyectistas.add(proyectista);
			}
		}

		return listaProyectistas;
	}

	/**
	 *  contextSubmission
	 *            ContextSubmissionEvent
	 *  detailInfo
	 *            DetailInfo
	 *  ComunicacionApertura.
	 *
	 * @param contextSubmission the context submission
	 * @param detailInfo the detail info
	 * @return the comunicacion apertura
	 */
	public ComunicacionApertura crearComunicacionAperturaDetailInfo(
			ContextSubmissionEvent contextSubmission, DetailInfo detailInfo) {

		GrupoDatosEmpresa datosEmpresa = detailInfo.getGrupoDatosEmpresa();
		GrupoDatosCentroTrabajo datosCentro = detailInfo
				.getGrupoDatosCentroTrabajo();
		GrupoDatosObra datosObra = detailInfo.getGrupoDatosObra();
		// DatosHolder1 datosTitular = detailInfo.getDatosHolder1();
		Datosrepresentative1 datosRepresentante = detailInfo
				.getDatosrepresentative1();

		Obra obra = null;
		if (datosObra != null
				&& !Utilities.getInstance().isEmpty(
						datosObra.getCampoTipoObra())) {
			obra = AperturaSolTelConverter.getInstance().crearObraDetailInfo(
					datosObra);
		}
		ComunicacionApertura apertura = new ComunicacionApertura();
		apertura.setObra(obra);

		apertura.setFolderId056(contextSubmission.getFolderID());
		// terape se rellena al final
		// anoape y numape se rellenan por SQL en la insert

		apertura.setFecpre056(PlateaTramitacionUtils.getInstance()
				.parsearTimestampPlatea(
						contextSubmission.getCreationTimestamp()));
		apertura.setFecalt056(apertura.getFecpre056());
		apertura.setDoccorrecta056(Constantes.VALUE_NO);
		apertura.setMigrado056(Constantes.VALUE_NO);

		apertura.setNueva056(ToolkitUtils.getInstance()
				.convertirRadioEmpresaNuevaExistente(
						datosEmpresa.getCampoRadioEmpresa()));
		apertura.setTipdoc056(ToolkitUtils.getInstance()
				.convertirTipoIdentificacion(datosEmpresa.getCampoTipoIdent()));
		apertura.setNumdoc056(datosEmpresa.getCampoNIFCIF());
		apertura.setNomemp056(datosEmpresa.getCampoRazonSocial());
		apertura.setPaisemp056(datosEmpresa.getCampoPaisEmpresa());
		apertura.setProvinciaEmp(new Provincia(datosEmpresa
				.getCampoProvinciaEmpresa()));
		apertura.setMunicipioEmp(new Municipio(datosEmpresa
				.getCampoMunicipioEmpresa()));
		apertura.setDiremp056(ToolkitUtils.getInstance()
				.concatenarDireccionToolkit(
						datosEmpresa.getCampoCalleEmpresa(),
						datosEmpresa.getCampoNumPortalEmpresa(),
						datosEmpresa.getCampoPisoEmpresa(),
						datosEmpresa.getCampoLetraEmpresa()));
		apertura.setCpoemp056(datosEmpresa.getCampoCodPostalEmpresa());
		apertura.setTlfemp056(datosEmpresa.getCampoTelefonoEmpresa());
		// TODO rellenar campo cnae empresa
		apertura.setTipoApertura(new TipoApertura(datosCentro
				.getCampoRadioObraSub()));
		apertura.setProvinciaCtr(new Provincia(datosCentro
				.getCampoProvinciaCentro()));
		apertura.setMunicipioCtr(new Municipio(datosCentro
				.getCampoMunicipioCentro()));
		apertura.setLocctr056(datosCentro.getCampoLocalidadCentro());
		apertura.setDirctr056(datosCentro.getCampoCalleCentro());
		apertura.setCpoctr056(datosCentro.getCampoCodPostalCentro());
		apertura.setTlfctr056(datosCentro.getCampoTelefonoCentro());
		apertura.setFaxctr056(datosCentro.getCampoFaxCentro());
		apertura.setEmailctr056(datosCentro.getCampoEmailCentro());
		// TODO rellenar campo cnae centro
		apertura.setPrvss056(datosCentro.getCampoNumSS0());
		apertura.setNumss056(datosCentro.getCampoNumSS1());
		apertura.setDigss056(datosCentro.getCampoNumSS2());
		apertura.setFecini056(ToolkitUtils.getInstance().parsearFecha(
				datosCentro.getFechaInicioActividad()));
		if (!Utilities.getInstance().isEmpty(
				datosCentro.getCampoNumTrabajadoresHombres())) {
			apertura.setTrbhom056(Long.parseLong(datosCentro
					.getCampoNumTrabajadoresHombres()));
		}
		if (!Utilities.getInstance().isEmpty(
				datosCentro.getCampoNumTrabajadoresMujeres())) {
			apertura.setTrbmuj056(Long.parseLong(datosCentro
					.getCampoNumTrabajadoresMujeres()));
		}
		if (!Utilities.getInstance().isEmpty(
				datosCentro.getCampoNumTrabajadoresTotal())) {
			apertura.setTrbtot056(Long.parseLong(datosCentro
					.getCampoNumTrabajadoresTotal()));
		}
		apertura.setClasctr056(datosCentro.getCampoClaseCentroTrabajo());
		apertura.setIndobra056(ToolkitUtils.getInstance().convertirRadioSN(
				datosCentro.getCampoRadioObra()));
		if (Constantes.VALUE_SI.equals(apertura.getIndobra056())) {
			apertura.setDescobr056(datosCentro.getCampoNombreCentro());
		} else if (Constantes.VALUE_NO.equals(apertura.getIndobra056())) {
			apertura.setNomctr056(datosCentro.getCampoNombreCentro());
		}
		if (!Utilities.getInstance().isEmpty(
				datosCentro.getCampoSuperficieConstruida())) {
			apertura.setSuperf056(Integer.parseInt(datosCentro
					.getCampoSuperficieConstruida()));
		}
		apertura.setPlanseg056(ToolkitUtils.getInstance().convertirRadioSiNo(
				datosObra.getCampoRadioPlanSeguridad()));
		apertura.setCanalplan056(datosObra.getCampoPlanEvalRiesgosFormaEnvio());
		apertura.setDescmaq056(datosCentro
				.getGrupoDatosProduccionAlmacenamiento().getCampoMaquinaria());
		if (datosCentro.getGrupoDatosProduccionAlmacenamiento()
				.getCampoPotenciaInstalada() != null) {
			apertura.setPoten056(new BigDecimal(datosCentro
					.getGrupoDatosProduccionAlmacenamiento()
					.getCampoPotenciaInstalada()));
		}
		apertura.setIndanx056(ToolkitUtils.getInstance().convertirRadioSiNo(
				datosCentro.getGrupoDatosProduccionAlmacenamiento()
						.getCampoRadioTrabajosAnexoI()));
		apertura.setApdoanx056(datosCentro
				.getGrupoDatosProduccionAlmacenamiento()
				.getCampoApartadoAnexoI());
		apertura.setDestrab056(datosCentro
				.getGrupoDatosProduccionAlmacenamiento()
				.getCampoDescripcionTrabajo());
		// TODO número registro inscripción empresas acreditadas son tres campos
		// (REGEMP_056)
		apertura.setCodentiat056(datosEmpresa.getCampoEntidad());
		apertura.setEntiat056(datosEmpresa.getCampoDescEntidad());
		if (!Utilities.getInstance().isEmpty(
				datosCentro.getCampoModalidadOrganizacion())) {
			apertura.setModpre056(Integer.parseInt(datosCentro
					.getCampoModalidadOrganizacion()));
		}
		if (!Utilities.getInstance().isEmpty(
				datosObra.getCampoNumPrevistoSubcontratistas())) {
			apertura.setNumcnt056(Long.parseLong(datosObra
					.getCampoNumPrevistoSubcontratistas()));
		}
		apertura.setEvalpres056(ToolkitUtils.getInstance().convertirRadioSiNo(
				datosObra.getCampoRadioPlanEvalRiesgos()));
		apertura.setCanaleval056(datosObra.getCampoPlanEvalRiesgosFormaEnvio());
		if (datosRepresentante != null) {
			apertura.setTlfrepresentante056(datosRepresentante
					.getCampoTelefonoRepresentante());
		}
		// TODO forma de presentación
		// apertura.setForpre056(forpre056);

		// Ponemos el código de territorio al final, ya que se necesita tener el
		// indicador de obra y los códigos de provincia del centro y de obra
		apertura.setTerape056(ToolkitUtils.getInstance()
				.obtenerTerritorioSolicitudApertura(apertura));

		apertura.setNumdocrepresentante056(contextSubmission.getSenderID());

		return apertura;
	}

}
